/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.common.item.StoneChip;
import cy.jdkdigital.productivebees.common.item.WoodChip;
import cy.jdkdigital.productivebees.common.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.common.recipe.ConfigurableHoneycombRecipe;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.integrations.jei.AdvancedBeehiveRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeBreedingRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeConversionRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeFishingRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeFloweringRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeSpawningRecipeBigCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeSpawningRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BlockConversionRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BottlerRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.CentrifugeRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.IncubationRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientHelper;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientRenderer;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ProductiveBeesJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = new ResourceLocation("productivebees", "productivebees");
    public static final ResourceLocation CATEGORY_ADVANCED_BEEHIVE_UID = new ResourceLocation("productivebees", "advanced_beehive");
    public static final ResourceLocation CATEGORY_BEE_BREEDING_UID = new ResourceLocation("productivebees", "bee_breeding");
    public static final ResourceLocation CATEGORY_BEE_CONVERSION_UID = new ResourceLocation("productivebees", "bee_conversion");
    public static final ResourceLocation CATEGORY_BEE_FISHING_UID = new ResourceLocation("productivebees", "bee_fishing");
    public static final ResourceLocation CATEGORY_BEE_SPAWNING_UID = new ResourceLocation("productivebees", "bee_spawning");
    public static final ResourceLocation CATEGORY_BEE_SPAWNING_BIG_UID = new ResourceLocation("productivebees", "bee_spawning_big");
    public static final ResourceLocation CATEGORY_CENTRIFUGE_UID = new ResourceLocation("productivebees", "centrifuge");
    public static final ResourceLocation CATEGORY_BEE_FLOWERING_UID = new ResourceLocation("productivebees", "bee_flowering");
    public static final ResourceLocation CATEGORY_INCUBATION_UID = new ResourceLocation("productivebees", "incubation");
    public static final ResourceLocation CATEGORY_BLOCK_CONVERSION_UID = new ResourceLocation("productivebees", "block_conversion");
    public static final ResourceLocation CATEGORY_BOTTLER_UID = new ResourceLocation("productivebees", "bottler");
    public static final IIngredientType<BeeIngredient> BEE_INGREDIENT = () -> BeeIngredient.class;

    public ProductiveBeesJeiPlugin() {
        BeeIngredientFactory.getOrCreateList();
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ADVANCED_OAK_BEEHIVE.get()), new ResourceLocation[]{CATEGORY_ADVANCED_BEEHIVE_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CENTRIFUGE.get()), new ResourceLocation[]{CATEGORY_CENTRIFUGE_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.POWERED_CENTRIFUGE.get()), new ResourceLocation[]{CATEGORY_CENTRIFUGE_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.COARSE_DIRT_NEST.get()), new ResourceLocation[]{CATEGORY_BEE_SPAWNING_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.OAK_WOOD_NEST.get()), new ResourceLocation[]{CATEGORY_BEE_SPAWNING_BIG_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INCUBATOR.get()), new ResourceLocation[]{CATEGORY_INCUBATION_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BOTTLER.get()), new ResourceLocation[]{CATEGORY_BOTTLER_UID});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AdvancedBeehiveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeBreedingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeConversionRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CentrifugeRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeFishingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeSpawningRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeSpawningRecipeBigCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeFloweringRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new IncubationRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockConversionRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BottlerRecipeCategory(guiHelper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        Collection<BeeIngredient> ingredients = BeeIngredientFactory.getOrCreateList(true).values();
        registration.register(BEE_INGREDIENT, new ArrayList<BeeIngredient>(ingredients), (IIngredientHelper)new BeeIngredientHelper(), (IIngredientRenderer)new BeeIngredientRenderer());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.WOOD_CHIP.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.STONE_CHIP.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.CONFIGURABLE_HONEYCOMB.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.CONFIGURABLE_SPAWN_EGG.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.CONFIGURABLE_COMB_BLOCK.get()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        Map advancedBeehiveRecipesMap = recipeManager.m_44054_(ModRecipeTypes.ADVANCED_BEEHIVE_TYPE);
        registration.addRecipes(advancedBeehiveRecipesMap.values(), CATEGORY_ADVANCED_BEEHIVE_UID);
        Map centrifugeRecipesMap = recipeManager.m_44054_(ModRecipeTypes.CENTRIFUGE_TYPE);
        registration.addRecipes(centrifugeRecipesMap.values(), CATEGORY_CENTRIFUGE_UID);
        Map beeFishingRecipesMap = recipeManager.m_44054_(ModRecipeTypes.BEE_FISHING_TYPE);
        registration.addRecipes(beeFishingRecipesMap.values(), CATEGORY_BEE_FISHING_UID);
        Map beeSpawningRecipesMap = recipeManager.m_44054_(ModRecipeTypes.BEE_SPAWNING_TYPE);
        registration.addRecipes(beeSpawningRecipesMap.values(), CATEGORY_BEE_SPAWNING_UID);
        Map beeSpawningRecipesBigMap = recipeManager.m_44054_(ModRecipeTypes.BEE_SPAWNING_BIG_TYPE);
        registration.addRecipes(beeSpawningRecipesBigMap.values(), CATEGORY_BEE_SPAWNING_BIG_UID);
        Map beeBreedingRecipeMap = recipeManager.m_44054_(ModRecipeTypes.BEE_BREEDING_TYPE);
        registration.addRecipes(beeBreedingRecipeMap.values(), CATEGORY_BEE_BREEDING_UID);
        Map beeConversionRecipeMap = recipeManager.m_44054_(ModRecipeTypes.BEE_CONVERSION_TYPE);
        registration.addRecipes(beeConversionRecipeMap.values(), CATEGORY_BEE_CONVERSION_UID);
        Map blockConversionRecipeMap = recipeManager.m_44054_(ModRecipeTypes.BLOCK_CONVERSION_TYPE);
        registration.addRecipes(blockConversionRecipeMap.values(), CATEGORY_BLOCK_CONVERSION_UID);
        Map bottlerRecipeMap = recipeManager.m_44054_(ModRecipeTypes.BOTTLER_TYPE);
        registration.addRecipes(bottlerRecipeMap.values(), CATEGORY_BOTTLER_UID);
        List<String> notInfoBees = Arrays.asList("minecraft:bee", "configurable_bee");
        Map<String, BeeIngredient> beeList = BeeIngredientFactory.getOrCreateList();
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            String beeId = entry.getKey().replace("productivebees:", "");
            if (notInfoBees.contains(beeId)) continue;
            TextComponent description = new TextComponent("");
            if (entry.getValue().isConfigurable()) {
                CompoundTag nbt = BeeReloadListener.INSTANCE.getData(entry.getKey());
                if (nbt.m_128441_("description")) {
                    description = new TranslatableComponent(nbt.m_128461_("description"));
                }
                if (!nbt.m_128471_("selfbreed")) {
                    description = new TranslatableComponent("productivebees.ingredient.description.selfbreed", new Object[]{description});
                }
            } else {
                description = new TranslatableComponent("productivebees.ingredient.description." + beeId);
                if (beeId.equals("lumber_bee") || beeId.equals("quarry_bee") || beeId.equals("rancher_bee") || beeId.equals("collector_bee") || beeId.equals("hoarder_bee") || beeId.equals("farmer_bee") || beeId.equals("cupid_bee")) {
                    description = new TranslatableComponent("productivebees.ingredient.description.selfbreed", new Object[]{description});
                }
            }
            if (description.getString().isEmpty()) continue;
            registration.addIngredientInfo((Object)entry.getValue(), BEE_INGREDIENT, new Component[]{description});
        }
        registration.addRecipes(BeeFloweringRecipeCategory.getFlowersRecipes(beeList), CATEGORY_BEE_FLOWERING_UID);
        registration.addRecipes(IncubationRecipeCategory.getRecipes(beeList), CATEGORY_INCUBATION_UID);
        List<String> itemInfos = Arrays.asList("inactive_dragon_egg", "dragon_egg_hive", "bumble_bee_nest", "sugar_cane_nest", "slimy_nest", "stone_nest", "sand_nest", "snow_nest", "gravel_nest", "coarse_dirt_nest", "oak_wood_nest", "spruce_wood_nest", "acacia_wood_nest", "dark_oak_wood_nest", "jungle_wood_nest", "birch_wood_nest", "end_stone_nest", "obsidian_nest", "glowstone_nest", "soul_sand_nest", "nether_brick_nest", "nether_quartz_nest");
        for (String itemName : itemInfos) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", itemName));
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("productivebees.ingredient.description." + itemName)});
        }
        ArrayList chipRecipes = new ArrayList();
        ArrayList chipHiveRecipes = new ArrayList();
        Registry.f_122824_.m_206058_(ModTags.QUARRY).forEach(blockHolder -> {
            Block b = (Block)blockHolder.m_203334_();
            chipRecipes.add(StoneChip.getRecipe(b));
            String[] id = b.getRegistryName().toString().split(":");
            HashMap<Ingredient, IntArrayTag> blockItemOutput = new HashMap<Ingredient, IntArrayTag>();
            blockItemOutput.put(Ingredient.m_43929_((ItemLike[])new ItemLike[]{b.m_5456_()}), new IntArrayTag(new int[]{1, 7, 100}));
            chipHiveRecipes.add(new AdvancedBeehiveRecipe(new ResourceLocation("productivebees", "stone_chip_block_hive_" + id[1]), (Lazy<BeeIngredient>)Lazy.of(() -> (BeeIngredient)beeList.get("productivebees:quarry_bee")), blockItemOutput));
            HashMap<Ingredient, IntArrayTag> chipItemOutput = new HashMap<Ingredient, IntArrayTag>();
            chipItemOutput.put(Ingredient.m_43927_((ItemStack[])new ItemStack[]{StoneChip.getStack(b)}), new IntArrayTag(new int[]{1, 7, 100}));
            chipHiveRecipes.add(new AdvancedBeehiveRecipe(new ResourceLocation("productivebees", "stone_chip_hive_" + id[1]), (Lazy<BeeIngredient>)Lazy.of(() -> (BeeIngredient)beeList.get("productivebees:quarry_bee")), chipItemOutput));
        });
        Registry.f_122824_.m_206058_(ModTags.LUMBER).forEach(blockHolder -> {
            Block b = (Block)blockHolder.m_203334_();
            chipRecipes.add(WoodChip.getRecipe(b));
            String[] id = b.getRegistryName().toString().split(":");
            HashMap<Ingredient, IntArrayTag> blockItemOutput = new HashMap<Ingredient, IntArrayTag>();
            blockItemOutput.put(Ingredient.m_43929_((ItemLike[])new ItemLike[]{b.m_5456_()}), new IntArrayTag(new int[]{1, 7, 100}));
            chipHiveRecipes.add(new AdvancedBeehiveRecipe(new ResourceLocation("productivebees", "wood_chip_block_hive_" + id[1]), (Lazy<BeeIngredient>)Lazy.of(() -> (BeeIngredient)beeList.get("productivebees:lumber_bee")), blockItemOutput));
            HashMap<Ingredient, IntArrayTag> chipItemOutput = new HashMap<Ingredient, IntArrayTag>();
            chipItemOutput.put(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WoodChip.getStack(b)}), new IntArrayTag(new int[]{1, 7, 100}));
            chipHiveRecipes.add(new AdvancedBeehiveRecipe(new ResourceLocation("productivebees", "wood_chip_hive_" + id[1]), (Lazy<BeeIngredient>)Lazy.of(() -> (BeeIngredient)beeList.get("productivebees:lumber_bee")), chipItemOutput));
        });
        registration.addRecipes(chipRecipes, VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipes(chipHiveRecipes, CATEGORY_ADVANCED_BEEHIVE_UID);
        Optional honeycombRecipe = recipeManager.m_44043_(new ResourceLocation("productivebees", "comb_block/configurable_honeycomb"));
        int count = 4;
        if (honeycombRecipe.isPresent()) {
            count = ((ConfigurableHoneycombRecipe)honeycombRecipe.get()).count;
        }
        ArrayList<ShapelessRecipe> recipes = new ArrayList<ShapelessRecipe>();
        for (Map.Entry<String, CompoundTag> entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
            String beeType = entry.getKey();
            ResourceLocation idComb = new ResourceLocation(beeType + "_honeycomb");
            ResourceLocation idCombBlock = new ResourceLocation(beeType + "_comb");
            ItemStack comb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
            BeeCreator.setTag(beeType, comb);
            NonNullList combInput = NonNullList.m_122779_();
            for (int i = 0; i < count; ++i) {
                combInput.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{comb}));
            }
            ItemStack combBlock = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
            BeeCreator.setTag(beeType, combBlock);
            NonNullList combBlockInput = NonNullList.m_122779_();
            combBlockInput.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{combBlock}));
            recipes.add(new ShapelessRecipe(idComb, "", combBlock, combInput));
            ItemStack combOutput = comb.m_41777_();
            combOutput.m_41764_(count);
            recipes.add(new ShapelessRecipe(idCombBlock, "", combOutput, combBlockInput));
        }
        registration.addRecipes(RecipeTypes.CRAFTING, recipes);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        Collection<BeeIngredient> ingredients = BeeIngredientFactory.getRBeesIngredients().values();
        if (ingredients.size() > 0) {
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(BEE_INGREDIENT, new ArrayList<BeeIngredient>(ingredients));
        }
    }
}

